package com.ejie.ab04b.service;

import java.util.List;

import org.springframework.beans.factory.annotation.Autowired;
import org.springframework.stereotype.Service;
import org.springframework.transaction.annotation.Transactional;

import com.ejie.ab04b.dao.RegimenJuridicoDao;
import com.ejie.ab04b.model.RegimenJuridico;
import com.ejie.x38.dto.JQGridRequestDto;
import com.ejie.x38.dto.JQGridResponseDto;
import com.ejie.x38.dto.TableRowDto;

/**
 * RegimenJuridicoServiceImpl generated by UDA, 27-sep-2016 13:26:09.
 * 
 * @author UDA
 */

@Service(value = "regimenJuridicoService")
public class RegimenJuridicoServiceImpl implements RegimenJuridicoService {

	@Autowired
	private RegimenJuridicoDao regimenJuridicoDao;

	/**
	 * Inserts a single row in the RegimenJuridico table.
	 * 
	 *  regimenJuridico
	 *            RegimenJuridico
	 *  RegimenJuridico
	 *
	 * @param regimenJuridico the regimen juridico
	 * @return the regimen juridico
	 */
	@Transactional(rollbackFor = Throwable.class)
	public RegimenJuridico add(RegimenJuridico regimenJuridico) {
		return this.regimenJuridicoDao.add(regimenJuridico);
	}

	/**
	 * Updates a single row in the RegimenJuridico table.
	 * 
	 *  regimenJuridico
	 *            RegimenJuridico
	 *  RegimenJuridico
	 *
	 * @param regimenJuridico the regimen juridico
	 * @return the regimen juridico
	 */
	@Transactional(rollbackFor = Throwable.class)
	public RegimenJuridico update(RegimenJuridico regimenJuridico) {
		return this.regimenJuridicoDao.update(regimenJuridico);
	}

	/**
	 * Finds a single row in the RegimenJuridico table.
	 * 
	 *  regimenJuridico
	 *            RegimenJuridico
	 *  RegimenJuridico
	 *
	 * @param regimenJuridico the regimen juridico
	 * @return the regimen juridico
	 */
	public RegimenJuridico find(RegimenJuridico regimenJuridico) {
		return (RegimenJuridico) this.regimenJuridicoDao.find(regimenJuridico);
	}

	/**
	 * Deletes a single row in the RegimenJuridico table.
	 * 
	 *  regimenJuridico
	 *            RegimenJuridico
	 *
	 * @param regimenJuridico the regimen juridico
	 */
	@Transactional(rollbackFor = Throwable.class)
	public void remove(RegimenJuridico regimenJuridico) {
		this.regimenJuridicoDao.remove(regimenJuridico);
	}

	/**
	 * Finds a list of rows in the RegimenJuridico table.
	 * 
	 *  regimenJuridico
	 *            RegimenJuridico
	 *  jqGridRequestDto
	 *            JQGridRequestDto
	 *  List<RegimenJuridico>
	 *
	 * @param regimenJuridico the regimen juridico
	 * @param jqGridRequestDto the jq grid request dto
	 * @return the list
	 */
	public List<RegimenJuridico> findAll(RegimenJuridico regimenJuridico,
			JQGridRequestDto jqGridRequestDto) {
		return (List<RegimenJuridico>) this.regimenJuridicoDao.findAll(
				regimenJuridico, jqGridRequestDto);
	}

	/**
	 * Finds rows in the RegimenJuridico table using like.
	 * 
	 *  regimenJuridico
	 *            RegimenJuridico
	 *  jqGridRequestDto
	 *            JQGridRequestDto
	 *  startsWith
	 *            Boolean
	 *  List<RegimenJuridico>
	 *
	 * @param regimenJuridico the regimen juridico
	 * @param jqGridRequestDto the jq grid request dto
	 * @param startsWith the starts with
	 * @return the list
	 */
	public List<RegimenJuridico> findAllLike(RegimenJuridico regimenJuridico,
			JQGridRequestDto jqGridRequestDto, Boolean startsWith) {
		return (List<RegimenJuridico>) this.regimenJuridicoDao.findAllLike(
				regimenJuridico, jqGridRequestDto, startsWith);
	}

	/*
	 * OPERACIONES RUP_TABLE
	 */

	/**
	 * Filter method in the RegimenJuridico table.
	 * 
	 *  filterRegimenJuridico
	 *            RegimenJuridico
	 *  jqGridRequestDto
	 *            JQGridRequestDto
	 *  startsWith
	 *            Boolean
	 *  JQGridResponseDto<RegimenJuridico>
	 *
	 * @param filterRegimenJuridico the filter regimen juridico
	 * @param jqGridRequestDto the jq grid request dto
	 * @param startsWith the starts with
	 * @return the JQ grid response dto
	 */
	public JQGridResponseDto<RegimenJuridico> filter(
			RegimenJuridico filterRegimenJuridico,
			JQGridRequestDto jqGridRequestDto, Boolean startsWith) {
		List<RegimenJuridico> listaRegimenJuridico = this.regimenJuridicoDao
				.findAllLike(filterRegimenJuridico, jqGridRequestDto, false);
		Long recordNum = this.regimenJuridicoDao.findAllLikeCount(
				filterRegimenJuridico != null ? filterRegimenJuridico
						: new RegimenJuridico(), false);
		if (jqGridRequestDto.getMultiselection().getSelectedIds() != null) {
			List<TableRowDto<RegimenJuridico>> reorderSelection = this.regimenJuridicoDao
					.reorderSelection(filterRegimenJuridico, jqGridRequestDto,
							startsWith);
			return new JQGridResponseDto<RegimenJuridico>(jqGridRequestDto,
					recordNum, listaRegimenJuridico, reorderSelection);
		}
		return new JQGridResponseDto<RegimenJuridico>(jqGridRequestDto,
				recordNum, listaRegimenJuridico);
	}

	/**
	 * Reorder the selection made in RegimenJuridico table.
	 * 
	 *  filterRegimenJuridico
	 *            RegimenJuridico
	 *  jqGridRequestDto
	 *            JQGridRequestDto
	 *  startsWith
	 *            Boolean
	 *  Object
	 *
	 * @param filterRegimenJuridico the filter regimen juridico
	 * @param jqGridRequestDto the jq grid request dto
	 * @param startsWith the starts with
	 * @return the object
	 */
	public Object reorderSelection(RegimenJuridico filterRegimenJuridico,
			JQGridRequestDto jqGridRequestDto, Boolean startsWith) {
		return this.regimenJuridicoDao.reorderSelection(filterRegimenJuridico,
				jqGridRequestDto, startsWith);
	}

}
